package Juno2;

import java.util.Enumeration;
import java.util.ResourceBundle;


public class CmdDAOFactory {

    private static boolean initialized = false;
	private static CmdDAO dao = null;
	private static CmdDAOFactory factoryInstance = null;
    	
    private CmdDAOFactory() { }
    
    public static synchronized CmdDAOFactory getInstance() {
		if (factoryInstance == null)
  		    factoryInstance = new CmdDAOFactory();
    	return factoryInstance;
    }
    
    public final static CmdDAO getDAO () {
    	makeDAO();
		return dao;	
    } 
    
    public final static synchronized boolean makeDAO () {
    	
    	if(!initialized) {
    		
			initialized = true;	
			System.out.println("Getting the ResourceBundle");
				
			ResourceBundle rb = ResourceBundle.getBundle(CmdConstants.CMDCONFIGNAME);
							
			System.out.println ("Got Resource Bundle");
				
			Enumeration e1 = rb.getKeys();
			while (e1.hasMoreElements()) {
				String key = (String) e1.nextElement();
				String value =rb.getString(key);
				System.out.println ("Key " + key + " is " + value);		
			}
			
			System.out.println("Instantiating DAO: " + rb.getString(CmdConstants.DAONAME));

			try {
				dao = (CmdDAO)(Class.forName(rb.getString(CmdConstants.DAONAME)).newInstance());
				dao.init(rb);
			} catch (Exception e) {
				System.out.println("Error Instantiating DAO " + rb.getString(CmdConstants.DAONAME) + ": " + e.getMessage());
			}
    	}
		return true;	
    }
}


